/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.util;

import net.minecraft.world.phys.Vec3;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;

public record PortalLocalXYNormalized(double nx, double ny) {
    public Vec3 getOffset(UnilateralPortalState state) {
        return state.orientation().rotate(new Vec3((this.nx - 0.5) * state.width(), (this.ny - 0.5) * state.height(), 0.0));
    }

    public Vec3 getPos(UnilateralPortalState state) {
        return state.position().m_82549_(this.getOffset(state));
    }

    public Vec3 getOffset(Portal portal) {
        return portal.axisW.m_82490_((this.nx - 0.5) * portal.width).m_82549_(portal.axisH.m_82490_((this.ny - 0.5) * portal.height));
    }

    public Vec3 getPos(Portal portal) {
        return portal.getOriginPos().m_82549_(this.getOffset(portal));
    }

    public static PortalLocalXYNormalized fromOffset(UnilateralPortalState state, Vec3 offset) {
        Vec3 localPos = state.orientation().getConjugated().rotate(offset);
        return new PortalLocalXYNormalized(localPos.f_82479_ / state.width() + 0.5, localPos.f_82480_ / state.height() + 0.5);
    }

    public static PortalLocalXYNormalized fromPos(UnilateralPortalState state, Vec3 pos) {
        return PortalLocalXYNormalized.fromOffset(state, pos.m_82546_(state.position()));
    }

    public static PortalLocalXYNormalized fromOffset(Portal portal, Vec3 offset) {
        return new PortalLocalXYNormalized(portal.axisW.m_82526_(offset) / portal.width + 0.5, portal.axisH.m_82526_(offset) / portal.height + 0.5);
    }

    public static PortalLocalXYNormalized fromPos(Portal portal, Vec3 pos) {
        return PortalLocalXYNormalized.fromOffset(portal, pos.m_82546_(portal.getOriginPos()));
    }

    public PortalLocalXYNormalized clamp() {
        return new PortalLocalXYNormalized(Math.min(Math.max(this.nx, 0.0), 1.0), Math.min(Math.max(this.ny, 0.0), 1.0));
    }

    public PortalLocalXYNormalized snapToGrid(int gridCount) {
        return new PortalLocalXYNormalized((double)Math.round(this.nx * (double)gridCount) / (double)gridCount, (double)Math.round(this.ny * (double)gridCount) / (double)gridCount);
    }

    public boolean isValid() {
        return this.nx >= 0.0 && this.nx <= 1.0 && this.ny >= 0.0 && this.ny <= 1.0;
    }

    public boolean isCloseTo(PortalLocalXYNormalized another, double maxDistance) {
        double distSq = (this.nx - another.nx) * (this.nx - another.nx) + (this.ny - another.ny) * (this.ny - another.ny);
        return distSq < maxDistance * maxDistance;
    }

    public PortalLocalXYNormalized add(PortalLocalXYNormalized another) {
        return new PortalLocalXYNormalized(this.nx + another.nx, this.ny + another.ny);
    }

    public PortalLocalXYNormalized subtract(PortalLocalXYNormalized another) {
        return new PortalLocalXYNormalized(this.nx - another.nx, this.ny - another.ny);
    }
}

